<?php

include 'config.php';
include 'login_check.php';

if (!isset($_GET['id']) || ($_GET['id'] == '')) {
  header('HTTP/1.0 404 Forbidden', TRUE, 404);
  die("<h2>Not Found!</h2> This page not available to public.");
}

// $encryptId = $_GET['id'];
// $ciphering_value = "AES-128-CTR";
// $decryption_key = "avcampusadmissions";
// $id = openssl_decrypt($encryptId, $ciphering_value, $decryption_key);
$id = $_GET['id'];

$stmt = $link2->prepare("SELECT * FROM teaching_appraisal WHERE teaching_appraisal_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result(); // get the mysqli result
$formData = $result->fetch_assoc(); // fetch the data

if (empty($formData)) {
  header('HTTP/1.0 404 Forbidden', TRUE, 404);
  die("<h2>Not Found!</h2> This page not available to public.");
}


$researchData = [];

$sql = "SELECT * FROM research_journal WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    if($data->year_2020_2021 == 1){
      $year = "year_2020_2021";
    }
    if($data->year_2021_2022 == 1){
      $year = "year_2021_2022";
    }
    if($data->year_2022_2023 == 1){
      $year = "year_2022_2023";
    }
    $researchData[$year]["journal"][] = [
      'conference' => $data->conference,
      'publications' => $data->publications,
      'journal_doi' => $data->journal_doi,
      'journal_index' => $data->journal_index,
      'date' => date('d-M-Y',strtotime($data->journal_date)),
      'name' => $data->journal_name,
      'author' => $data->journal_author
    ];
  }
}

$sql = "SELECT * FROM research_book WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    if($data->year_2020_2021 == 1){
      $year = "year_2020_2021";
    }
    if($data->year_2021_2022 == 1){
      $year = "year_2021_2022";
    }
    if($data->year_2022_2023 == 1){
      $year = "year_2022_2023";
    }
    $researchData[$year]["book"][] = [
      'name' => $data->book_title,
      'publisher' => $data->publisher,
      'author' => $data->author,
      'date' => date('d-M-Y',strtotime($data->publication_date)),
      'number' => $data->book_number,
      'chapter' => json_decode($data->chapter_data)
    ];
  }
}

$sql = "SELECT * FROM research_patent WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    if($data->year_2020_2021 == 1){
      $year = "year_2020_2021";
    }
    if($data->year_2021_2022 == 1){
      $year = "year_2021_2022";
    }
    if($data->year_2022_2023 == 1){
      $year = "year_2022_2023";
    }
    $type = '';
    if($data->patent_type == 1){
      $type = 'Design';
    }
    if($data->patent_type == 2){
      $type = 'Invention';
    }

    $researchData[$year]["patent"][] = [
      'type' => $type,
      'name' => $data->patent_name,
      'fillingDate' => date('d-M-Y',strtotime($data->filling_date)),
      'patentedDate' => date('d-M-Y',strtotime($data->patented_date))
    ];
  }
}

$sql = "SELECT * FROM research_seed WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    if($data->year_2020_2021 == 1){
      $year = "year_2020_2021";
    }
    if($data->year_2021_2022 == 1){
      $year = "year_2021_2022";
    }
    if($data->year_2022_2023 == 1){
      $year = "year_2022_2023";
    }

    $researchData[$year]["seed"][] = [
      'name' => $data->seed_name,
      'amountRequired' => $data->amount_required,
      'amountApproved' => $data->amount_approved,
      'status' => $data->status
    ];
  }
}

$sql = "SELECT * FROM research_external WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    if($data->year_2020_2021 == 1){
      $year = "year_2020_2021";
    }
    if($data->year_2021_2022 == 1){
      $year = "year_2021_2022";
    }
    if($data->year_2022_2023 == 1){
      $year = "year_2022_2023";
    }

    $researchData[$year]["external"][] = [
      'name' => $data->external_name,
      'amountRequired' => $data->amount_required,
      'amountApproved' => $data->amount_approved,
      'agency' => $data->agency,
      'status' => $data->status
    ];
  }
}

$workLoadData = [];
$sql = "SELECT * FROM work_load WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    if($data->is_odd == 1 ){
      $workLoadData['odd'][] = [
        'type' => $data->type,
        'subjects' => $data->subjects,
        'hours' => $data->no_hours,
        'percentage' => $data->pass_percentage
      ];
    }
    if($data->is_even == 1 ){
      $workLoadData['even'][] = [
        'type' => $data->type,
        'subjects' => $data->subjects,
        'hours' => $data->no_hours,
        'percentage' => $data->pass_percentage
      ];
    }
  }
}

$trainingData = [];
$sql = "SELECT * FROM training WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    $type = $data->training_type;
    $trainingData[] = [
      'type' => $type,
      'name' => $data->training_name,
      'days' => $data->no_days,
    ];
  }
}

$contributionData = [];
$sql = "SELECT * FROM contribution WHERE teaching_appraisal_id = ".$formData['teaching_appraisal_id'].";";
$result = mysqli_query($link2, $sql);
if (mysqli_num_rows($result) > 0) {
  while ($data = mysqli_fetch_object($result)) {
    $contributionData[] = [
      'name' => $data->name,
      'department' => $data->department,
      'type' => $data->type,
      'outcome' => $data->outcome,
    ];
  }
}

// echo '<pre>';
// print_r($formData);
// print_r($researchData);
// print_r($workLoadData);
// print_r($trainingData);

// echo '</pre>';
// die;

$researchDataHtml = '';
if(isset($researchData['year_2020_2021'])){
  $researchDataHtml .= getResearchData($researchData['year_2020_2021'], '2020-2021');
  $researchDataHtml .= '</br>';
}

if(isset($researchData['year_2021_2022'])){
  $researchDataHtml .= getResearchData($researchData['year_2021_2022'], '2021-2022');
  $researchDataHtml .= '</br>';
}

if(isset($researchData['year_2022_2023'])){
  $researchDataHtml .= getResearchData($researchData['year_2022_2023'], '2022-2023');
  $researchDataHtml .= '</br>';
}

$workLoadDataHtml = '';

if(isset($workLoadData['even'])){
  $workLoadDataHtml .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="4" style="font-size:16px">Work Load (Hrs) for 2023 - Even Semester</td>
          </tr>
          <tr>
            <td align="center"><strong>Subjects Handled</strong></td>
            <td align="center"><strong>Subjects Name</strong></td>
            <td align="center"><strong>No. of Hours</strong></td>
            <td align="center"><strong>Pass Percentage (%)</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($workLoadData['even'] as $even){
        $workLoadDataHtml .='<tr><td>'.$even['type'].'</td><td>'.$even['subjects'].'</td><td align="center">'.$even['hours'].'</td><td align="center">'.$even['percentage'].'</td></tr>';
      }

    $workLoadDataHtml .='</tbody></table></br>';
}

if(isset($workLoadData['odd'])){
  $workLoadDataHtml .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="4" style="font-size:16px">Work Load (Hrs) for 2023 - Odd Semester</td>
          </tr>
          <tr>
            <td align="center"><strong>Subjects Handled</strong></td>
            <td align="center"><strong>Subjects Name</strong></td>
            <td align="center"><strong>No. of Hours</strong></td>
            <td align="center"><strong>Pass Percentage (%)</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($workLoadData['odd'] as $odd){
        $workLoadDataHtml .='<tr><td>'.$odd['type'].'</td><td>'.$odd['subjects'].'</td><td align="center">'.$odd['hours'].'</td><td align="center">'.$odd['percentage'].'</td></tr>';
      }

    $workLoadDataHtml .='</tbody></table></br>';
}

$trainingDataHtml = '';
if(!empty($trainingData)){
  $trainingDataHtml .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="3" style="font-size:16px">Training</td>
          </tr>
          <tr>
            <td align="center"><strong>Training Type</strong></td>
            <td align="center"><strong>Training name</strong></td>
            <td align="center"><strong>No. of days</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($trainingData as $training){
        $trainingDataHtml .='<tr><td>'.$training['type'].'</td><td>'.$training['name'].'</td><td align="center">'.$training['days'].'</td></tr>';
      }

    $trainingDataHtml .='</tbody></table>';
}

$contributionDataHtml = '';
if(!empty($contributionData)){
  $contributionDataHtml .='
  
  <table width="100%" style="table-layout:fixed;">
    <thead style="background: #deebff;">
      <tr>
        <td colspan="4" style="font-size:17px">Additional Contribution with Outcome</td>
      </tr>
    </thead>
    <tbody>
    <tr>
      <td align="center" style="font-size:16px"><strong>Institution Name</strong></td>
      <td align="center" style="font-size:16px"><strong>Department</strong></td>
      <td align="center" style="font-size:16px"><strong>Type of Contribution</strong></td>
      <td align="center" style="font-size:16px"><strong>Outcome </strong></td>
    </tr>';
      foreach($contributionData as $contribution){
        $contributionDataHtml .='<tr><td>'.$contribution['name'].'</td><td>'.$contribution['department'].'</td><td>'.$contribution['type'].'</td><td>'.$contribution['outcome'].'</td></tr>';
      }

    $contributionDataHtml .='</tbody></table></br>';
}


$html = '<!doctype html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>APPRAISAL FORM</title>

<style type="text/css">
    * {
        font-family: Verdana, Arial, sans-serif;
    }
    table{
        font-size: 14px;
        border: 1px solid black;
        border-collapse: collapse;
    }
    th, td {
      padding:7px;
      border: 1px solid black;
      border-collapse: collapse;
      word-wrap: break-word;
    }
</style>

</head>
<body>

  <table width="100%">
    <tr style="border-style: hidden;">
        <td valign="top" style="border-style: hidden;"><img src="https://avcampusadmissions.com/teaching-appraisal/avit.new_.png" alt="" width="180"/></td>
        <td align="right" style="border-style: hidden;"><h3>APPRAISAL FORM - REGISTRATION FOR TEACHING FACULTY</h3></td>
    </tr>
  </table>
  </br>
  <table width="100%" style="table-layout:fixed;">
    <thead style="background: #deebff;">
      <tr>
        <td colspan="4" style="font-size:17px">Personal Information</td>
      </tr>
    </thead>
    <tbody>
    <tr>
      <td><strong>Employee ID</strong></td>
      <td>'.$formData['employee_id'].'</td>
      <td><strong>Name of the Faculty</strong></td>
      <td>'.$formData['full_name'].'</td>
    </tr>
    <tr>
      <td><strong>Department</strong></td>
      <td>'.$formData['department'].'</td>
      <td><strong>Designation</strong></td>
      <td>'.$formData['designation'].'</td>
    </tr>
    <tr>
      <td><strong>Date of Joining</strong></td>
      <td>'.date('d-M-Y',strtotime($formData['date_of_joining'])).'</td>
      <td><strong>Qualification</strong></td>
      <td>'.$formData['qualification'].'</td>
    </tr>
    <tr>
      <td><strong>Email ID</strong></td>
      <td>'.$formData['email'].'</td>
      <td><strong>Phone Number</strong></td>
      <td>'.$formData['phone_number'].'</td>
    </tr>
    </tbody>
  </table>
  </br>'.$researchDataHtml.$workLoadDataHtml.$contributionDataHtml.$trainingDataHtml.'
</body>
</html>';


function getResearchData($data, $year){
  $htmlData ='
      <table width="100%" style="table-layout:fixed;">
        <thead style="background: #fff3f3;">
        <tr>
          <td style="font-size:17px">Research Activities <strong>('.$year.')</strong></td>
        </tr>
        </thead>
      </table>';
  if(isset($data['journal'])){
    $htmlData .='
    <table width="100%" style="table-layout:fixed;">
      <thead>
          <tr style="background: #deebff;">
            <td colspan="7" style="font-size:16px">Journals</td>
          </tr>
          <tr style="background: #deebff;">
            <td align="center"><strong>Conference</strong></td>
            <td align="center"><strong>Journals & publications</strong></td>
            <td align="center"><strong>Name of the Journal</strong></td>
            <td align="center"><strong>Title of the Article & DOI No</strong></td>
            <td align="center"><strong>Date of Publication</strong></td>
            <td align="center"><strong>Author Type</strong></td>
            <td align="center"><strong>Indexed In</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($data['journal'] as $journal){
        $htmlData .='<tr><td>'.$journal['conference'].'</td><td>'.$journal['publications'].'</td><td>'.$journal['name'].'</td><td>'.$journal['journal_doi'].'</td><td>'.$journal['date'].'</td><td>'.$journal['author'].'</td><td>'.$journal['journal_index'].'</td></tr>';
      }

    $htmlData .='</tbody></table></br>';
  }
  
  if(isset($data['book'])){
    $htmlData .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="5" style="font-size:16px">Books</td>
          </tr>
          <tr>
            <td align="center"><strong>Title of the Book</strong></td>
            <td align="center"><strong>Date of Publication</strong></td>
            <td align="center"><strong>Author / Authors</strong></td>
            <td align="center"><strong>Publisher\'s Name</strong></td>
            <td align="center"><strong>ISBN/ISSN No</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($data['book'] as $book){
        $htmlData .='<tr><td colspan="5">Book Detail</td></tr>';
        $htmlData .='<tr><td>'.$book['name'].'</td><td>'.$book['date'].'</td><td>'.$book['author'].'</td><td>'.$book['publisher'].'</td><td>'.$book['number'].'</td></tr>';
        if(($book['chapter'] != null) && count($book['chapter']) > 0){
          $htmlData .='<tr><td colspan="5">Chapter Detail</td></tr>';
          foreach($book['chapter'] as $row){
            $htmlData .='<tr><td>'.$row->title.'</td><td>'.date('d-M-Y',strtotime($row->date)).'</td><td>'.$row->author.'</td><td>'.$row->publisher.'</td><td>'.$row->number.'</td></tr>';
          }

        }
      }

    $htmlData .='</tbody></table></br>';
  }
    
  if(isset($data['patent'])){
    $htmlData .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="4" style="font-size:16px">Patents</td>
          </tr>
          <tr>
            <td align="center"><strong>Type of Patent</strong></td>
            <td align="center"><strong>Date of Filing</strong></td>
            <td align="center"><strong>Title of the Patent</strong></td>
            <td align="center"><strong>Date of Patent Granted</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($data['patent'] as $patent){
        $htmlData .='<tr><td>'.$patent['type'].'</td><td>'.$patent['fillingDate'].'</td><td>'.$patent['name'].'</td><td>'.$patent['patentedDate'].'</td></tr>';
      }

    $htmlData .='</tbody></table></br>';
  }
    
  if(isset($data['seed'])){
    $htmlData .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="4" style="font-size:16px">Seed Money</td>
          </tr>
          <tr>
            <td align="center"><strong>Project Title</strong></td>
            <td align="center"><strong>Amount Required</strong></td>
            <td align="center"><strong>Amount Sanctioned</strong></td>
            <td align="center"><strong>Status</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($data['seed'] as $seed){
        $htmlData .='<tr><td>'.$seed['name'].'</td><td align="right">'.$seed['amountRequired'].'</td><td align="right">'.$seed['amountApproved'].'</td></td><td align="center">'.$seed['status'].'</td></tr>';
      }

    $htmlData .='</tbody></table></br>';
  }
    
  if(isset($data['external'])){
    $htmlData .='
      <table width="100%" style="table-layout:fixed;">
        <thead>
          <tr style="background: #deebff;">
            <td colspan="5" style="font-size:16px">External Fund</td>
          </tr>
          <tr>
            <td align="center"><strong>Project Title</strong></td>
            <td align="center"><strong>Amount Required</strong></td>
            <td align="center"><strong>Amount Sanctioned</strong></td>
            <td align="center"><strong>Funding Agency</strong></td>
            <td align="center"><strong>Status</strong></td>
          </tr>
        </thead>
        <tbody>';
      foreach($data['external'] as $external){
        $htmlData .='<tr><td>'.$external['name'].'</td><td align="right">'.$external['amountRequired'].'</td><td align="right">'.$external['amountApproved'].'</td><td>'.$external['agency'].'</td><td align="center">'.$external['status'].'</td></tr>';
      }

    $htmlData .='</tbody></table></br>';
  }

  return $htmlData;
}



require_once 'dompdf/autoload.inc.php'; //we've assumed that the dompdf directory is in the same directory as your PHP file. If not, adjust your autoload.inc.php i.e. first line of code accordingly.
// reference the Dompdf namespace
use Dompdf\Dompdf;
use Dompdf\Options;
// instantiate and use the dompdf class
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

$dompdf->loadHtml($html);
// (Optional) Setup the paper size and orientation
$dompdf->setPaper('A4', 'landscape');
// Render the HTML as PDF
$dompdf->render();
// Output the generated PDF to Browser
// $dompdf->stream(time().".pdf");
$dompdf->stream("APPRAISAL FORM.pdf", array("Attachment" => false));

exit(0);
